#include <vo_stdio.h>
#include <vs1010dRom.h>
#include <vo_gpio.h>
#include <vs1010c.h>
#include <string.h>
#include <lcd.h>

#include "fpga_pins.h"
//#include "i2cexpansion.h"

/* If use i2c implementation implemented here is wanted,
   #define USE_OLED_I2C
*/
#define OLED_I2C_ADDRESS 0x78

#ifdef USE_OLED_I2C
#define OLED_START() {GpioSetPin(I2C_SDA, 0); GpioSetPin(I2C_SCL, 0);}
#define OLED_STOP() {GpioSetPin(I2C_SCL,1); GpioSetPin(I2C_SDA,1);}
#else
void I2CStart();
ioresult I2CPutOctet(register u_int16 outdata);
void I2CStop();
#endif

#if 0

// Init vector, modified for ribbon cable facing downwards.
const unsigned char oledInit1306[]={
	0xae, //Display OFF
	//0x40, //Display start line is COM0
	0x5f, //Display start line is COM31
	0x81, //Set Contrast Control
	0xcf,
	0x20, //Set addressing mode
	0x02, //Page addressing mode
	//0xa0, //Segment remap (Horizontal direction)
	0xa1, //Segment remap (Horizontal direction)
	0xa4, //Entire display 0n
	//0xa7, //Inversed display
	0xa6, //non-inversed display
	0xa8, //Set multiplex ratio
	0x3f, //1/64
	//0xc0, //COM output scan direction
	0xc8, //COM output scan direction
	0xd3, //Display offset
	0x01,
	0xd5, //Set clock divider/oscillator frequency
	0x80, //105 Hz
	0xd9, //Set precharge period
	0xf1,
	0xda, //Set COM pins hardware configuration
	0x12,
	0xdb, //Set VCOMH deselect level
	0x30, //0.83 * VCC
	0x8d, //Charge pump setting
	0x14, //Enable charge pump, VCC=7.5V
	0xaf, //Display ON
};



// Init vector for ribbon cable facing upwards
const unsigned char oledInit1306[]={
	0xae, //Display OFF
	0x40, //Display start line is COM0
//	0x5f, //Display start line is COM31
	0x81, //Set Contrast Control
	0xcf,
	0x20, //Set addressing mode
	0x02, //Page addressing mode
	0xa0, //Segment remap (Horizontal direction)
//	0xa1, //Segment remap (Horizontal direction)
	0xa4, //Entire display 0n
	//0xa7, //Inversed display
	0xa6, //non-inversed display
	0xa8, //Set multiplex ratio
	0x3f, //1/64
	0xc0, //COM output scan direction
//	0xc8, //COM output scan direction
	0xd3, //Display offset
	0x01,
	0xd5, //Set clock divider/oscillator frequency
	0x80, //105 Hz
	0xd9, //Set precharge period
	0xf1,
	0xda, //Set COM pins hardware configuration
	0x12,
	0xdb, //Set VCOMH deselect level
	0x30, //0.83 * VCC
	0x8d, //Charge pump setting
	0x14, //Enable charge pump, VCC=7.5V
	0xaf, //Display ON
};
#endif
/* FPGAinit has this. */
#if 0
/* Packed init vector */
const __mem_y u_int16 init1306[] = {
	(0xae << 8) | /* Display OFF */	                 0x40, /* Display start line is COM0 */
	(0x81 << 8) | /* Set Contrast Control */         0xcf,
	(0x20 << 8) | /* Set addressing mode */          0x02, /* Page addressing mode */
	(0xa0 << 8) | /* Segment remap (Horizon dir) */  0xa4, /* Entire display 0n */
	(0xa6 << 8) | /* non-inversed display */         0xa8, /* Set multiplex ratio */
	(0x3f << 8) | /* 1/64 */                         0xc0, /* COM output scan dir */
	(0xd3 << 8) | /* Display offset */               0x01,
	(0xd5 << 8) | /* Set clock divider/xtal freq */  0x80, /* 105 Hz */
	(0xd9 << 8) | /* Set precharge period */         0xf1,
	(0xda << 8) | /* Set COM pins hardware config */ 0x12,
	(0xdb << 8) | /* Set VCOMH deselect level */     0x30, /* 0.83 * VCC */
	(0x8d << 8) | /* Charge pump setting */          0x14, /* Enable charge pump, VCC=7.5V */
	(0xaf << 8)   /* Display ON */
};
/* Look at above. Is it odd? */
#define OLED_ODD_INIT
#endif

#ifdef USE_OLED_I2C
/// Output one octet to the OLED, using I2C protocol, bitbang, fast.
/// Not compatible with generic I2C: too fast, ignores ack.
void OledPutOctet(register u_int16 c){
	register u_int16 i;
	for (i=0; i<9; i++){
		GpioSetPin(I2C_SDA, c&0x80);
		GpioSetPin(I2C_SCL, 1);
		GpioSetPin(I2C_SCL, 0);
		c <<= 1;
	}
}
#endif


#define OLED_COMMAND 0x80
#define OLED_DATA 0x40
#define ScreenPutCommand(a) ScreenPutCommandOrData(a, OLED_COMMAND)
#define ScreenPutData(a) ScreenPutCommandOrData(a, OLED_DATA)

void ScreenPutCommandOrData(register u_int16 value, register u_int16 oled_cmd_or_data) {
#ifdef USE_OLED_I2C
	OLED_START();
	OledPutOctet(OLED_I2C_ADDRESS);
	OledPutOctet(oled_cmd_or_data);
	OledPutOctet(value);
	OLED_STOP();
#else
	I2CStart();
	I2CPutOctet(OLED_I2C_ADDRESS);
	I2CPutOctet(oled_cmd_or_data);
	I2CPutOctet(value);
	I2CStop();
#endif
}


// Set x,y pointer of display controller
void ScreenLocate(register int x, register int y){
	y |= 0xB0;
	x += 32;
	ScreenPutCommand(y);
	ScreenPutCommand(x & 0x0f);
	ScreenPutCommand((x >> 4) | 0x0010);
}


void ScreenClear(){
	u_int16 x,y;
	for (y=0; y<8; y++){
		ScreenLocate(0,y);
		for (x=0; x<132; x++){
			ScreenPutData(0);
		}
	}
	ScreenLocate(0,0);
}


void OledPutBufferSingle(u_int16 *buf, u_int16 *nextWordAfter) {
	while (buf < nextWordAfter) ScreenPutData(*buf++);
}

#define TEXT_LATIN1 0
#define TEXT_SMALL 1
#define TEXT_UNIFONT 2

// Puts a string to column x, row y.
void OledPutStringXY(register u_int16 x, register u_int16 y, char *s) {
	u_int16 buf[64];
	u_int16 *next; //RenderChar, RenderString return ptr to next free pixelword after char or string
	ScreenLocate(x,y); //Column (0..63), Row(0..3)
	next = RenderString(s, buf, buf+sizeof(buf)); //in VS1010D ROM
	OledPutBufferSingle(buf, next); //Firstword, Lastword+1
}
#if 0
void OledInit() {
	u_int16 i, byte;
	__mem_y u_int16 *in = init1306;
	/* Reset cycle */
#ifdef USE_OLED_I2C
	OLED_STOP();
#else
	I2CStop();
#endif
	DelayL(100000);
	GpioSetPin(OLED_XRESET, 0);
	DelayL(100000);
	GpioSetPin(OLED_XRESET, 1);
	/* Controller config */
#ifdef OLED_ODD_INIT
	{
		u_int16 octets = sizeof init1306 * 2 - 1;
		for (i = 0; i < octets; i++) {
			if ((i & 1) == 0) {
				byte = *in >> 8;
			} else {
				byte = *in++ & 0xff;
			}
			ScreenPutCommand(byte);
		}
	}
#else
	{
		/* Untested */
		u_int16 words = sizeof init1306;
		for (i = 0; i < words; i++) {
			byte = *in >> 8;
			ScreenPutCommand(byte);
			byte = *in++ & 0xff;
			ScreenPutCommand(byte);
		}
	}
#endif
	ScreenClear();
	lcd0.charStyle = TEXT_SMALL;
	OledPutStringXY(0,0,"Universal");
	lcd0.charStyle = TEXT_LATIN1;
	OledPutStringXY(10,1,"FPGA");
}
#endif

/*
  ioresult main (char *params) {
  int i;


  OLED_STOP(); //STOP condition also resets the gpio pin states to their correct state
  GpioSetPin(OLED_XRESET, 1);
  DelayL(100000);
  GpioSetPin(OLED_XRESET, 0);
  DelayL(100000);
  GpioSetPin(OLED_XRESET, 1);

  for (i=0; i<sizeof(oledInit1306); i++) {
  ScreenPutCommand(oledInit1306[i]);
  }

  ScreenClear();

  lcd0.charStyle = TEXT_SMALL;
  OledPutStringXY(0,0,"Hello, World !");

  lcd0.charStyle = TEXT_LATIN1;
  OledPutStringXY(0,1,"WONDER");


  return S_OK;
  }

*/
